<?php

namespace App\Http\Requests;

use App\Enum\IsolatedMarginRequestStatus;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateIsolatedMarginRequestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'status' => ['required', Rule::in([
                IsolatedMarginRequestStatus::APPROVED->value,
                IsolatedMarginRequestStatus::DECLINED->value,
            ])],
            'admin_note' => ['nullable', 'string', 'max:500'],
        ];
    }
}
