<?php

namespace App\Http\Requests;

use App\Models\CopyTradePlan;
use Illuminate\Foundation\Http\FormRequest;

class UpdateCopyTradePlanRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $uuid = $this->route('copyTradePlan')->uuid;
        $plan = CopyTradePlan::where('uuid', $uuid)->first();

        return [
            'name' => ['required', 'unique:copy_trade_plans,name,' . $plan->id, 'string'],
            'type' => ['required', 'string'],
            'features' => ['required', 'array'],
            'minimum' => ['required', 'numeric'],
            'maximum' => ['required', 'numeric'],
            'daily_profit' => ['required', 'numeric', 'min:0', 'max:100'],
            'commission_percentage' => ['required', 'numeric', 'min:0', 'max:100'],
            'daily_profit_duration' => ['required', 'integer', 'min:1'],
            'trades_per_day' => ['required', 'integer', 'min:1'],
            'daily_profit_multiplication' => ['required', 'numeric', 'min:1'],
        ];
    }
}
