<?php

namespace App\Http\Requests;

use App\Enum\UserIdType;
use Illuminate\Foundation\Http\FormRequest;

class SubmitKycRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'country' => 'required|string|max:255',
            'address' => 'required|string|max:255',
            'city' => 'required|string|max:255',
            'state' => 'required|string|max:255',
            'zip_code' => 'required|string|max:20',
            'id_type' => ['required', 'in:' . implode(',', array_column(UserIdType::cases(), 'value'))],
            'id_front' => 'required|image|mimes:jpg,jpeg,png|max:2048',
            'id_back' => 'required|image|mimes:jpg,jpeg,png|max:2048',
        ];
    }
}
