<?php

namespace App\Http\Requests;

use App\Enum\TransactionType;
use App\Enum\TransactionDirection;
use Illuminate\Validation\Rules\Enum;
use Illuminate\Foundation\Http\FormRequest;

class StoreTransactionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'amount' => ['required', 'numeric', 'min:0.01'], // must be a valid number > 0
            'type' => ['required', new Enum(TransactionType::class)], // matches your schema enum
            'direction' => ['required', new Enum(TransactionDirection::class)], // matches your schema enum
            'transaction_at' => ['required'],
            'description' => ['nullable', 'string', 'max:255'], // optional text
            'notification' => ['required', 'in:none,email'], // select option
        ];
    }
}
