<?php

namespace App\Http\Requests;

use App\Enum\TraderStatus;
use App\Enum\TraderExperience;
use Illuminate\Foundation\Http\FormRequest;

class StoreTraderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'user_id' => 'required|exists:users,id',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'balance' => 'required|numeric',
            'status' => ['required', 'string', 'in:' . implode(',', array_column(TraderStatus::cases(), 'value')),],
            'experience' => ['required', 'string', 'in:' . implode(',', array_column(TraderExperience::cases(), 'value')),],
            'notes' => 'nullable|string',
        ];
    }
}
