<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreTradeBotRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'minimum' => ['required', 'numeric'],
            'maximum' => ['required', 'numeric'],
            'currency' => ['required', 'string', 'max:255'],
            'asset_pairs' => ['required', 'array'],
            'features' => ['required', 'array'],
            'parameters' => ['required', 'array'],
            'description' => ['nullable', 'string'],
        ];
    }
}
