<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StorePlanRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['required', 'unique:plans,name', 'string'],
            'type' => ['required', 'string'],
            'features' => ['required', 'array'],
            'trades_per_day' => ['required', 'numeric'],
            'minimum' => ['required', 'numeric'],
            'maximum' => ['required', 'numeric'],
            'daily_profit' => ['required', 'numeric'],
            'daily_profit_duration' => ['required', 'numeric'],
            'daily_profit_multiplication' => ['required', 'numeric'],
        ];
    }
}
