<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreCopyTradeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'trader_id' => ['required', 'exists:traders,id'],
            'description' => ['nullable', 'string', 'max:1000'],
            'initial_amount' => ['required', 'numeric', 'min:0'],
            'duration_hours' => ['nullable', 'integer', 'min:1'],
        ];
    }
}
