<?php

namespace App\Http\Controllers\Frontend;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Models\NewsletterSubscriber;

class NewsletterSubscriberController extends Controller
{
    public function unsubscribe(Request $request)
    {
        try {
            $subscriber = NewsletterSubscriber::where('email', $request->email)->firstOrFail();

            DB::beginTransaction();

            $subscriber->delete();

            DB::commit();

            return redirect()->route('home')->with('success', 'You have successfully unsubscribed from our newsletter.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error($e->getMessage());
            return redirect()->route('home')->with('error', config('app.messages.error'));
        }
    }
}
