<?php

namespace App\Http\Controllers\Dashboard\User;

use App\Models\User;
use App\Services\WalletService;
use App\Services\PriceService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class WalletController extends Controller
{
    public function __construct()
    {
        $this->middleware(['registeredUser', 'kycVerification']);
    }

    /**
     * Display user's wallet with all balances
     */
    public function index()
    {
        $user = Auth::user();

        // Ensure user has balance records for all markets
        WalletService::ensureUserHasAllMarketBalances($user);

        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('user.dashboard')],
            ['label' => 'Wallet', 'active' => true],
        ];

        // Get all user balances with market info
        $balances = WalletService::getUserBalances($user);

        // Calculate total portfolio value in USD
        $totalValueUSD = 0;
        $balancesWithValues = $balances->map(function ($balance) use (&$totalValueUSD) {
            // Extract symbol from asset (e.g., "BTC / USDT" -> "btc")
            $parts = explode('/', $balance->market->asset);
            $symbol = strtolower(trim($parts[0]));

            // Get current price in USD
            $priceUSD = PriceService::getPrice($symbol);

            // Calculate value
            $valueUSD = $balance->balance * $priceUSD;
            $totalValueUSD += $valueUSD;

            return [
                'id' => $balance->id,
                'market' => $balance->market,
                'balance' => $balance->balance,
                'symbol' => strtoupper($symbol),
                'price_usd' => $priceUSD,
                'value_usd' => $valueUSD,
            ];
        });

        $data = [
            'title' => 'My Wallet',
            'user' => $user,
            'breadcrumbs' => $breadcrumbs,
            'balances' => $balancesWithValues,
            'totalValueUSD' => $totalValueUSD,
        ];

        return view('dashboard.user.wallet.index', $data);
    }
}
