<?php

namespace App\Http\Controllers\Dashboard\User;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class SupportController extends Controller
{
    public function __construct()
    {
        $this->middleware(['registeredUser', 'kycVerification']);
    }

    public function index()
    {
        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('user.dashboard')],
            ['label' => 'Support', 'active' => true],
        ];

        $user = Auth::user();

        $data = [
            'title' => 'Support',
            'user' => $user,
            'breadcrumbs' => $breadcrumbs
        ];

        return view('dashboard.user.support.index', $data);
    }
}
