<?php

namespace App\Http\Controllers\Dashboard\User;

use App\Models\User;
use App\Models\Trade;
use App\Models\Market;
use App\Enum\TradeStatus;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Enum\TransactionType;
use App\Enum\InvestmentStatus;
use App\Enum\TransactionStatus;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware(['registeredUser', 'kycVerification']);
    }

    /**
     * Handle the incoming request.
     */
    public function __invoke(Request $request)
    {
        $user = Auth::user();

        $welcomeMessage = 'Welcome' . ' ' . $user->name;

        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('user.dashboard')],
            ['label' => $welcomeMessage, 'active' => true]
        ];

        $markets = Market::all();

        $totalProfits = Transaction::where('user_id', Auth::id())
            ->where('type', TransactionType::PROFIT)
            ->where('status', TransactionStatus::COMPLETED)
            ->sum('amount');

        $openTrades = Trade::where('user_id', Auth::id())
            ->where('status', TradeStatus::OPEN)
            ->count();

        $totalDeposits = Transaction::where('user_id', Auth::id())
            ->where('type', TransactionType::DEPOSIT)
            ->where('status', TransactionStatus::COMPLETED)
            ->sum('amount');

        $data = [
            'title' => $welcomeMessage,
            'user' => $user,
            'breadcrumbs' => $breadcrumbs,
            'markets' => $markets,
            'totalProfits' => $totalProfits,
            'openTrades' => $openTrades,
            'totalDeposits' => $totalDeposits
        ];

        return view('dashboard.user.index', $data);
    }
}
