<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class UserTradeController extends Controller
{
    public function index(string $uuid)
    {
        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('admin.dashboard')],
            ['label' => 'Users', 'url' => route('admin.user.index')],
            ['label' => 'User Details', 'url' => route('admin.user.show', $uuid)],
            ['label' => 'Trades', 'active' => true],
        ];

        $user = User::where('uuid', $uuid)->firstOrFail();
        $trades = $user->trades()->with(['market'])->latest()->get();

        $data = [
            'title' => 'Trades',
            'user' => $user,
            'breadcrumbs' => $breadcrumbs,
            'trades' => $trades
        ];

        return view('dashboard.admin.user.trade.index', $data);
    }

    public function show(string $uuid, string $trade_uuid)
    {
        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('admin.dashboard')],
            ['label' => 'Users', 'url' => route('admin.user.index')],
            ['label' => 'User Details', 'url' => route('admin.user.show', $uuid)],
            ['label' => 'Trades', 'url' => route('admin.user.trade.index', $uuid)],
            ['label' => 'Trade Details', 'active' => true],
        ];

        $user = User::where('uuid', $uuid)->firstOrFail();
        $trade = $user->trades()->where('uuid', $trade_uuid)->firstOrFail();

        $data = [
            'title' => 'Trade Details',
            'user' => $user,
            'trade' => $trade,
            'breadcrumbs' => $breadcrumbs
        ];

        return view('dashboard.admin.user.trade.show', $data);
    }
}
