<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Models\User;
use App\Models\Transaction;
use App\Enum\UserPlanStatus;
use Illuminate\Http\Request;
use App\Enum\TransactionStatus;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;

class UserPlanController extends Controller
{
    public function index(string $uuid)
    {
        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('admin.dashboard')],
            ['label' => 'Users', 'url' => route('admin.user.index')],
            ['label' => 'User Details', 'url' => route('admin.user.show', $uuid)],
            ['label' => 'Subscription Plans', 'active' => true],
        ];

        $user = User::where('uuid', $uuid)->firstOrFail();
        $userPlans = $user->userPlans()->with(['plan'])->latest()->get();

        $data = [
            'title' => 'Subscription Plans',
            'user' => $user,
            'breadcrumbs' => $breadcrumbs,
            'userPlans' => $userPlans
        ];

        return view('dashboard.admin.user.plan.index', $data);
    }

    public function show(string $userUUID, string $userPlanUUID)
    {
        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('admin.dashboard')],
            ['label' => 'Users', 'url' => route('admin.user.index')],
            ['label' => 'User Details', 'url' => route('admin.user.show', $userUUID)],
            ['label' => 'Subscription Plans', 'url' => route('admin.user.plan.index', $userUUID)],
            ['label' => 'Plan Details', 'active' => true],
        ];

        $user = User::where('uuid', $userUUID)->firstOrFail();
        $userPlan = $user->userPlans()->where('uuid', $userPlanUUID)->firstOrFail();

        $data = [
            'title' => 'Plan Details',
            'user' => $user,
            'breadcrumbs' => $breadcrumbs,
            'userPlan' => $userPlan,
        ];

        return view('dashboard.admin.user.plan.show', $data);
    }
}
