<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Models\User;
use App\Enum\UserKycStatus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;

class UserKycController extends Controller
{
    public function index(string $uuid)
    {
        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('admin.dashboard')],
            ['label' => 'Users', 'url' => route('admin.user.index')],
            ['label' => 'User Details', 'url' => route('admin.user.show', $uuid)],
            ['label' => 'KYC Verification', 'active' => true]
        ];

        $user = User::where('uuid', $uuid)->firstOrFail();

        $data = [
            'title' => 'KYC Verification',
            'user' => $user,
            'breadcrumbs' => $breadcrumbs
        ];

        return view('dashboard.admin.user.kyc.index', $data);
    }

    public function update(Request $request, string $uuid)
    {
        $request->validate([
            'status' => 'required|in:approved,rejected'
        ]);

        $user = User::where('uuid', $uuid)->firstOrFail();

        try {
            DB::beginTransaction();

            if ($request->status === 'approved') {
                $user->update([
                    'kyc_status' => UserKycStatus::APPROVED->value
                ]);

                // Send notification to user
            } else {
                $user->update([
                    'kyc_status' => UserKycStatus::REJECTED->value
                ]);

                // Send notification to user
            }

            DB::commit();
            return redirect()->route('admin.user.kyc', $uuid)->with('success', 'KYC status updated successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error($e->getMessage());
            return redirect()->route('admin.user.kyc', $uuid)->with('error', config('app.messages.error'));
        }
    }
}
