<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Models\Trader;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\TraderSubscription;

class TraderSubscriptionController extends Controller
{
    public function index(string $traderUUID)
    {
        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('admin.dashboard')],
            ['label' => 'Traders', 'url' => route('admin.trader.index')],
            ['label' => 'Trader Details', 'url' => route('admin.trader.show', $traderUUID)],
            ['label' => 'Trader Subscriptions', 'active' => true],
        ];

        $trader = Trader::where('uuid', $traderUUID)->firstOrFail();
        $traderSubscriptions = TraderSubscription::with(['user'])->where('trader_id', $trader->id)->latest()->get();

        $data = [
            'title' => 'Trader Subscriptions',
            'breadcrumbs' => $breadcrumbs,
            'trader' => $trader,
            'traderSubscriptions' => $traderSubscriptions
        ];

        return view('dashboard.admin.trader_subscription.index', $data);
    }
}
