<?php

namespace App\Http\Controllers\Auth;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;

class TwoFactorAuthenticationController extends Controller
{
    public function index(Request $request)
    {
        try {
            $user = User::where('role', 'user')->where('uuid', $request->id)->firstOrFail();

            $data = [
                'title' => 'Two-Factor Authentication',
                'user' => $user
            ];

            return view('auth.two_factor_authentication', $data);
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return redirect()->route('login')->with('error', config('app.messages.error'));
        }
    }

    public function store(Request $request) {}

    public function send(Request $request) {}
}
