<?php

namespace App\Enum;

enum WalletStatus: string
{
    case ACTIVE = 'active';
    case INACTIVE = 'inactive';

    public function label()
    {
        return match ($this) {
            self::ACTIVE => 'Active',
            self::INACTIVE => 'Inactive',
        };
    }

    public function badge()
    {
        return match ($this) {
            self::ACTIVE => 'badge bg-success-subtle text-success fs-12 p-1',
            self::INACTIVE => 'badge bg-danger-subtle text-danger fs-12 p-1',
        };
    }
}
