<?php

namespace App\Enum;

enum UserTwoFactorEnabled: int
{
    case ENABLED = 1;
    case DISABLED = 0;

    public function label()
    {
        return match ($this) {
            self::ENABLED => 'Enabled',
            self::DISABLED => 'Disabled',
        };
    }

    public function badge()
    {
        return match ($this) {
            self::ENABLED => 'badge bg-success-subtle text-success fs-12 p-1',
            self::DISABLED => 'badge bg-danger-subtle text-danger fs-12 p-1',
        };
    }

    public function textColor()
    {
        return match ($this) {
            self::ENABLED => 'text-success',
            self::DISABLED => 'text-danger',
        };
    }
}
