<?php

namespace App\Enum;

enum UserIdType: string
{
    case PASSPORT = 'passport';
    case DRIVER_LICENSE = 'driver_license';
    case OTHER = 'other';

    public function label()
    {
        return match ($this) {
            self::PASSPORT => 'Passport',
            self::DRIVER_LICENSE => 'Driver\'s License',
            self::OTHER => 'Other',
        };
    }
}
