<?php

namespace App\Enum;

enum UserCopyTradePlanStatus: string
{
    case ACTIVE = 'active';
    case COMPLETED = 'completed';
    case CANCELLED = 'cancelled';

    public function label(): string
    {
        return match ($this) {
            self::ACTIVE => 'Active',
            self::COMPLETED => 'Completed',
            self::CANCELLED => 'Cancelled',
        };
    }

    public function badge()
    {
        return match ($this) {
            self::ACTIVE => 'badge bg-success-subtle text-success fs-12 p-1',
            self::COMPLETED => 'badge bg-success-subtle text-success fs-12 p-1',
            self::CANCELLED => 'badge bg-danger-subtle text-danger fs-12 p-1',
        };
    }
}
