<?php

namespace App\Enum;

enum UserAccountMode: int
{
    case LIVE = 1;
    case DEMO = 0;

    public function label(): string
    {
        return match ($this) {
            self::LIVE => 'Live',
            self::DEMO => 'Demo',
        };
    }

    public function textColor(): string
    {
        return match ($this) {
            self::LIVE => 'text-success',
            self::DEMO => 'text-info',
        };
    }

    public function badge(): string
    {
        return match ($this) {
            self::LIVE => 'badge bg-success-subtle text-success fs-12 p-1',
            self::DEMO => 'badge bg-info-subtle text-info fs-12 p-1',
        };
    }
}
