<?php

namespace App\Enum;

enum TransactionType: string
{
    case DEPOSIT = 'deposit';
    case WITHDRAW = 'withdraw';
    case PROFIT = 'profit';
    case PLAN_SUBSCRIPTION = 'plan_subscription';
    case COPY_TRADE = 'copy_trade';
    case COMMISSION = 'commission';
    case CAPITAL_RETURN = 'capital_return';

    public function label(): string
    {
        return match ($this) {
            self::DEPOSIT => 'Deposit',
            self::WITHDRAW => 'Withdraw',
            self::PROFIT => 'Profit',
            self::PLAN_SUBSCRIPTION => 'Plan Subscription',
            self::COPY_TRADE => 'Copy Trade',
            self::COMMISSION => 'Commission',
            self::CAPITAL_RETURN => 'Capital Return',
        };
    }
}
