<?php

namespace App\Enum;

enum TransactionStatus: string
{
    case PENDING = 'pending';
    case COMPLETED = 'completed';
    case FAILED = 'failed';
    case CANCELLED = 'cancelled';

    public function label(): string
    {
        return match ($this) {
            self::PENDING => 'Pending',
            self::COMPLETED => 'Completed',
            self::FAILED => 'Failed',
            self::CANCELLED => 'Cancelled',
        };
    }

    public function badge(): string
    {
        return match ($this) {
            self::PENDING => 'badge bg-warning-subtle text-warning fs-12 p-1',
            self::COMPLETED => 'badge bg-success-subtle text-success fs-12 p-1',
            self::FAILED => 'badge bg-danger-subtle text-danger fs-12 p-1',
            self::CANCELLED => 'badge bg-danger-subtle text-danger fs-12 p-1',
        };
    }
}
