<?php

namespace App\Enum;

enum TransactionDirection: string
{
    case CREDIT = 'credit';
    case DEBIT = 'debit';

    public function label(): string
    {
        return match ($this) {
            self::CREDIT => 'Credit',
            self::DEBIT => 'Debit',
        };
    }

    public function badge(): string
    {
        return match ($this) {
            self::CREDIT => 'badge bg-success-subtle text-success fs-12 p-1',
            self::DEBIT => 'badge bg-danger-subtle text-danger fs-12 p-1',
        };
    }
}
