<?php

namespace App\Enum;

enum TradeStatus: string
{
    case OPEN = 'open';
    case CLOSED = 'closed';

    public function label(): string
    {
        return match ($this) {
            self::OPEN => 'Open',
            self::CLOSED => 'Closed',
        };
    }

    public function badge(): string
    {
        return match ($this) {
            self::OPEN => 'badge bg-success-subtle text-success fs-12 p-1',
            self::CLOSED => 'badge bg-danger-subtle text-danger fs-12 p-1',
        };
    }
}
