<?php

namespace App\Enum;

enum TradeBotUserStatus: string
{
    case RUNNING = 'running';
    case STOPPED = 'stopped';
    case PAUSED = 'paused';

    public function label(): string
    {
        return match ($this) {
            self::RUNNING => 'Running',
            self::STOPPED => 'Stopped',
            self::PAUSED => 'Paused',
        };
    }

    public function badge(): string
    {
        return match ($this) {
            self::RUNNING => 'badge bg-success-subtle text-success fs-12 p-1',
            self::STOPPED => 'badge bg-danger-subtle text-danger fs-12 p-1',
            self::PAUSED => 'badge bg-warning-subtle text-warning fs-12 p-1',
        };
    }
}
