<?php

namespace App\Enum;

enum SignalDuration: int
{
    case ONE_MINUTE   = 1;
    case TWO_MINUTES  = 2;
    case FIVE_MINUTES = 5;
    case TEN_MINUTES  = 10;
    case THIRTY_MINUTES = 30;

    case ONE_HOUR   = 60;
    case TWO_HOURS  = 120;
    case THREE_HOURS = 180;
    case SIX_HOURS  = 360;
    case TWELVE_HOURS = 720;
    case TWENTY_FOUR_HOURS = 1440;

    public function label(): string
    {
        return match ($this) {
            self::ONE_MINUTE => '1 minute',
            self::TWO_MINUTES => '2 minutes',
            self::FIVE_MINUTES => '5 minutes',
            self::TEN_MINUTES => '10 minutes',
            self::THIRTY_MINUTES => '30 minutes',
            self::ONE_HOUR => '1 hour',
            self::TWO_HOURS => '2 hours',
            self::THREE_HOURS => '3 hours',
            self::SIX_HOURS => '6 hours',
            self::TWELVE_HOURS => '12 hours',
            self::TWENTY_FOUR_HOURS => '24 hours',
        };
    }

    public static function options(): array
    {
        return collect(self::cases())->map(fn($case) => [
            'value' => $case->value,
            'label' => $case->label(),
        ])->toArray();
    }
}
