<?php

namespace App\Enum;

enum PlanType: string
{
    case BASIC = 'basic';
    case ADVANCED = 'advanced';
    case PREMIUM = 'premium';

    public function label(): string
    {
        return match ($this) {
            self::BASIC => 'Basic',
            self::ADVANCED => 'Advanced',
            self::PREMIUM => 'Premium',
        };
    }
}
