<?php

namespace App\Enum;

enum Currency: string
{
    case USD = 'United State Dollar-USD-$';
    // case EUR = 'Euro-EUR-€';
    // case GBP = 'British Pound-GBP-£';
    // case BTC = 'Bitcoin-BTC-₿';
    // case ETH = 'Ethereum-ETH-Ξ';

    public function label(): string
    {
        return match ($this) {
            self::USD => 'United State Dollar-USD-$',
            // self::EUR => 'Euro-EUR-€',
            // self::GBP => 'British Pound-GBP-£',
            // self::BTC => 'Bitcoin-BTC-₿',
            // self::ETH => 'Ethereum-ETH-Ξ',
        };
    }

    public function symbol(): string
    {
        return match ($this) {
            self::USD => '$',
            // self::EUR => '€',
            // self::GBP => '£',
            // self::BTC => '₿',
            // self::ETH => 'Ξ',
        };
    }

    public function code(): string
    {
        return match ($this) {
            self::USD => 'USD',
            // self::EUR => 'EUR',
            // self::GBP => 'GBP',
            // self::BTC => 'BTC',
            // self::ETH => 'ETH',
        };
    }

    public function name(): string
    {
        return match ($this) {
            self::USD => 'US Dollar',
            // self::EUR => 'Euro',
            // self::GBP => 'British Pound',
            // self::BTC => 'Bitcoin',
            // self::ETH => 'Ethereum',
        };
    }
}
