<?php

namespace App\Enum;

enum CopyTradeRequestStatus: string
{
    case PENDING = 'pending';
    case APPROVED = 'approved';
    case DECLINED = 'declined';

    public function label(): string
    {
        return match ($this) {
            self::PENDING => 'Pending',
            self::APPROVED => 'Approved',
            self::DECLINED => 'Declined',
        };
    }

    public function badge(): string
    {
        return match ($this) {
            self::PENDING => 'badge bg-warning-subtle text-warning fs-12 p-1',
            self::APPROVED => 'badge bg-success-subtle text-success fs-12 p-1',
            self::DECLINED => 'badge bg-danger-subtle text-danger fs-12 p-1',
        };
    }
}
