<?php

// @formatter:off
// phpcs:ignoreFile
/**
 * A helper file for your Eloquent Models
 * Copy the phpDocs from this file to the correct Model,
 * And remove them from this file, to prevent double declarations.
 *
 * @author Barry vd. Heuvel <barryvdh@gmail.com>
 */


namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property string $name
 * @property string|null $description
 * @property numeric $initial_amount
 * @property numeric $profit_loss
 * @property \App\Enum\CopyTradeStatus $status
 * @property int|null $trader_id
 * @property int|null $duration_hours
 * @property \Illuminate\Support\Carbon|null $started_at
 * @property \Illuminate\Support\Carbon|null $ended_at
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\CopyTradeParticipant> $participants
 * @property-read int|null $participants_count
 * @property-read \App\Models\Trader|null $trader
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\User> $users
 * @property-read int|null $users_count
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade whereDurationHours($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade whereEndedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade whereInitialAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade whereProfitLoss($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade whereStartedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade whereTraderId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTrade whereUuid($value)
 */
	class CopyTrade extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $copy_trade_id
 * @property int $user_id
 * @property numeric $invested_amount
 * @property numeric $profit_loss
 * @property numeric $unrealized_profit
 * @property bool $is_active
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\CopyTrade $copyTrade
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeParticipant newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeParticipant newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeParticipant query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeParticipant whereCopyTradeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeParticipant whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeParticipant whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeParticipant whereInvestedAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeParticipant whereIsActive($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeParticipant whereProfitLoss($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeParticipant whereUnrealizedProfit($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeParticipant whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeParticipant whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeParticipant whereUuid($value)
 */
	class CopyTradeParticipant extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property string $name
 * @property \App\Enum\PlanType $type
 * @property numeric $minimum
 * @property numeric $maximum
 * @property numeric $daily_profit Daily profit percentage to be credited
 * @property numeric $commission_percentage Percentage of profits taken as commission
 * @property int $duration_days Plan duration in days
 * @property array<array-key, mixed>|null $features
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\UserCopyTradePlan> $userCopyTradePlans
 * @property-read int|null $user_copy_trade_plans_count
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan whereCommissionPercentage($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan whereDailyProfit($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan whereDurationDays($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan whereFeatures($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan whereMaximum($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan whereMinimum($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradePlan whereUuid($value)
 */
	class CopyTradePlan extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property int $trader_id
 * @property \App\Enum\CopyTradeRequestStatus $status
 * @property int $is_automated_started
 * @property string|null $admin_note
 * @property \Illuminate\Support\Carbon|null $reviewed_at
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Trader $trader
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeRequest newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeRequest newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeRequest query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeRequest whereAdminNote($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeRequest whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeRequest whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeRequest whereIsAutomatedStarted($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeRequest whereReviewedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeRequest whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeRequest whereTraderId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeRequest whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeRequest whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|CopyTradeRequest whereUuid($value)
 */
	class CopyTradeRequest extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property int|null $wallet_id
 * @property numeric $amount
 * @property \App\Enum\IsolatedMarginRequestStatus $status
 * @property string|null $proof
 * @property string|null $admin_note
 * @property \Illuminate\Support\Carbon|null $reviewed_at
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\User $user
 * @property-read \App\Models\Wallet|null $wallet
 * @method static \Illuminate\Database\Eloquent\Builder<static>|IsolatedMarginRequest newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|IsolatedMarginRequest newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|IsolatedMarginRequest query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|IsolatedMarginRequest whereAdminNote($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|IsolatedMarginRequest whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|IsolatedMarginRequest whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|IsolatedMarginRequest whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|IsolatedMarginRequest whereProof($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|IsolatedMarginRequest whereReviewedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|IsolatedMarginRequest whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|IsolatedMarginRequest whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|IsolatedMarginRequest whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|IsolatedMarginRequest whereUuid($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|IsolatedMarginRequest whereWalletId($value)
 */
	class IsolatedMarginRequest extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property string $asset
 * @property string $symbol
 * @property numeric $rate
 * @property numeric $price
 * @property numeric $high
 * @property numeric $low
 * @property numeric $volume
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Signal> $signals
 * @property-read int|null $signals_count
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereAsset($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereHigh($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereLow($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market wherePrice($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereRate($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereSymbol($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereUuid($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereVolume($value)
 */
	class Market extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property string $subject
 * @property string $content
 * @property string|null $sent_at
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter whereContent($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter whereSentAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter whereSubject($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter whereUuid($value)
 */
	class Newsletter extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property string $email
 * @property string|null $subscribed_at
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber whereSubscribedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber whereUuid($value)
 */
	class NewsletterSubscriber extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property string $title
 * @property string $description
 * @property \App\Enum\NotificationStatus $read
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereRead($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereTitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereUuid($value)
 */
	class Notification extends \Eloquent {}
}

namespace App\Models{
/**
 * @property string $email
 * @property string $token
 * @property \Illuminate\Support\Carbon|null $created_at
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PasswordResetToken newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PasswordResetToken newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PasswordResetToken query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PasswordResetToken whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PasswordResetToken whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PasswordResetToken whereToken($value)
 */
	class PasswordResetToken extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property string $name
 * @property \App\Enum\PlanType $type
 * @property numeric $minimum
 * @property numeric $maximum
 * @property numeric $daily_profit
 * @property int $daily_profit_duration
 * @property int $daily_profit_multiplication
 * @property int $trades_per_day
 * @property array<array-key, mixed>|null $features
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\UserPlan> $userPlans
 * @property-read int|null $user_plans_count
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereDailyProfit($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereDailyProfitDuration($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereDailyProfitMultiplication($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereFeatures($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereMaximum($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereMinimum($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereTradesPerDay($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereUuid($value)
 */
	class Plan extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property int $plan_id
 * @property string $telegram_username
 * @property string $transaction_id
 * @property string|null $proof
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Plan $plan
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription wherePlanId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereProof($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereTelegramUsername($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereTransactionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereUuid($value)
 */
	class PremiumSignalSubscription extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string|null $registration_token
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Setting newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Setting newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Setting query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Setting whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Setting whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Setting whereRegistrationToken($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Setting whereUpdatedAt($value)
 */
	class Setting extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $market_id
 * @property \App\Enum\SignalType $type
 * @property int $unit
 * @property int $amount
 * @property \App\Enum\SignalAction $action
 * @property \App\Enum\SignalDuration $duration
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Market $market
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereAction($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereDuration($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereMarketId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereUnit($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereUuid($value)
 */
	class Signal extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property int $from_market_id
 * @property int $to_market_id
 * @property numeric $from_amount
 * @property numeric|null $to_amount
 * @property numeric $rate
 * @property numeric $fee
 * @property string $status
 * @property \Illuminate\Support\Carbon|null $swapped_at
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Market $fromMarket
 * @property-read \App\Models\Market $toMarket
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap whereFee($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap whereFromAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap whereFromMarketId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap whereRate($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap whereSwappedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap whereToAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap whereToMarketId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Swap whereUuid($value)
 */
	class Swap extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property int $market_id
 * @property int|null $trade_bot_user_id
 * @property \App\Enum\TradeType $type
 * @property \App\Enum\TradeMode $mode
 * @property numeric $amount
 * @property numeric $entry_price
 * @property numeric|null $exit_price
 * @property numeric $profit
 * @property \App\Enum\TradeStatus $status
 * @property \Illuminate\Support\Carbon $opened_at
 * @property \Illuminate\Support\Carbon|null $closed_at
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Market $market
 * @property-read \App\Models\TradeBotUser|null $tradeBotUser
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereClosedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereEntryPrice($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereExitPrice($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereMarketId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereMode($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereOpenedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereProfit($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereTradeBotUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereUuid($value)
 */
	class Trade extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property string $name
 * @property numeric $minimum
 * @property numeric $maximum
 * @property \App\Enum\Currency $currency
 * @property array<array-key, mixed> $asset_pairs
 * @property array<array-key, mixed> $features
 * @property array<array-key, mixed> $parameters
 * @property string|null $description
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot whereAssetPairs($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot whereCurrency($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot whereFeatures($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot whereMaximum($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot whereMinimum($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot whereParameters($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot whereUuid($value)
 */
	class TradeBot extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property int $trade_bot_id
 * @property numeric $amount
 * @property string $leverage
 * @property \App\Enum\TradeBotUserStatus $status
 * @property \Illuminate\Support\Carbon|null $started_at
 * @property string|null $paused_at
 * @property string|null $stopped_at
 * @property array<array-key, mixed>|null $meta
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\TradeBot $tradeBot
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Trade> $trades
 * @property-read int|null $trades_count
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser whereLeverage($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser whereMeta($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser wherePausedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser whereStartedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser whereStoppedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser whereTradeBotId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBotUser whereUuid($value)
 */
	class TradeBotUser extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property string|null $image
 * @property numeric $balance
 * @property \App\Enum\TraderStatus $status
 * @property \App\Enum\TraderExperience|null $experience
 * @property string|null $notes
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\CopyTradeRequest> $copyTradeRequests
 * @property-read int|null $copy_trade_requests_count
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\CopyTrade> $copyTrades
 * @property-read int|null $copy_trades_count
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\TraderSubscription> $subscriptions
 * @property-read int|null $subscriptions_count
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereExperience($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereNotes($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereUuid($value)
 */
	class Trader extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $trader_id
 * @property int $user_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Trader $trader
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription whereTraderId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription whereUuid($value)
 */
	class TraderSubscription extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property \App\Enum\TransactionType $type
 * @property \App\Enum\TransactionDirection $direction
 * @property string|null $description
 * @property numeric $amount
 * @property \App\Enum\TransactionMethod|null $method
 * @property string|null $proof
 * @property string|null $transaction_at
 * @property string $reference_id
 * @property string|null $other_reference_id
 * @property string|null $note
 * @property array<array-key, mixed>|null $meta
 * @property \App\Enum\TransactionStatus $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereDirection($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereMeta($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereMethod($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereNote($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereOtherReferenceId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereProof($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereReferenceId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereTransactionAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereUuid($value)
 */
	class Transaction extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property \App\Enum\UserRole $role
 * @property string $name
 * @property string $email
 * @property string|null $email_code
 * @property string|null $email_code_expires_at
 * @property \Illuminate\Support\Carbon|null $email_verified_at
 * @property string|null $phone
 * @property string|null $gender
 * @property string $password
 * @property string|null $password_plain
 * @property string|null $registration_token
 * @property string|null $country
 * @property string|null $address
 * @property string|null $city
 * @property string|null $state
 * @property string|null $zip_code
 * @property \App\Enum\UserKycStatus $kyc_status
 * @property \App\Enum\UserIdType|null $id_type
 * @property string|null $id_front
 * @property string|null $id_back
 * @property numeric $balance
 * @property numeric $profit_balance
 * @property numeric $demo_balance
 * @property string $signal_strength
 * @property string|null $secret_key
 * @property string|null $api_key
 * @property \App\Enum\UserAccountMode $account_mode
 * @property \App\Enum\UserAccountType $account_type
 * @property \App\Enum\Currency $currency
 * @property \App\Enum\UserTwoFactorEnabled $two_factor_enabled
 * @property string|null $image
 * @property string|null $wallet_address
 * @property numeric $wallet_balance
 * @property \App\Enum\UserStatus $status
 * @property \Illuminate\Support\Carbon|null $last_login_at
 * @property string|null $last_login_ip
 * @property string|null $remember_token
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property \App\Enum\DividendStatus $dividend_status
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\CopyTradeParticipant> $copyTradeParticipations
 * @property-read int|null $copy_trade_participations_count
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\CopyTradeRequest> $copyTradeRequests
 * @property-read int|null $copy_trade_requests_count
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\CopyTrade> $copyTrades
 * @property-read int|null $copy_trades_count
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\IsolatedMarginRequest> $isolatedMarginRequests
 * @property-read int|null $isolated_margin_requests_count
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Notification> $notification
 * @property-read int|null $notification_count
 * @property-read \Illuminate\Notifications\DatabaseNotificationCollection<int, \Illuminate\Notifications\DatabaseNotification> $notifications
 * @property-read int|null $notifications_count
 * @property-read \App\Models\PremiumSignalSubscription|null $premiumSignalSubscription
 * @property-read \App\Models\Trader|null $trader
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Trade> $trades
 * @property-read int|null $trades_count
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Transaction> $transaction
 * @property-read int|null $transaction_count
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\UserCopyTradePlan> $userCopyTradePlans
 * @property-read int|null $user_copy_trade_plans_count
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\UserPlan> $userPlans
 * @property-read int|null $user_plans_count
 * @method static \Database\Factories\UserFactory factory($count = null, $state = [])
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereAccountMode($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereAccountType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereAddress($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereApiKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereCity($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereCountry($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereCurrency($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereDemoBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereEmailCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereEmailCodeExpiresAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereEmailVerifiedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereGender($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereIdBack($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereIdFront($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereIdType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereKycStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereLastLoginAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereLastLoginIp($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User wherePassword($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User wherePasswordPlain($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User wherePhone($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereProfitBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereRegistrationToken($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereRememberToken($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereRole($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereSecretKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereSignalStrength($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereState($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereTwoFactorEnabled($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereUuid($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereWalletAddress($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereWalletBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereZipCode($value)
 */
	class User extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property int $market_id
 * @property numeric $balance
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Market $market
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserBalance newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserBalance newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserBalance query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserBalance whereBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserBalance whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserBalance whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserBalance whereMarketId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserBalance whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserBalance whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserBalance whereUuid($value)
 */
	class UserBalance extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property int $copy_trade_plan_id
 * @property numeric $amount Amount deducted from wallet balance
 * @property numeric $daily_profit Daily profit percentage at subscription time
 * @property numeric $commission_percentage
 * @property numeric $unrealized_profit
 * @property int $duration_days
 * @property \Illuminate\Support\Carbon|null $starts_at
 * @property \Illuminate\Support\Carbon|null $ends_at
 * @property \App\Enum\UserCopyTradePlanStatus $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\CopyTradePlan $copyTradePlan
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan whereCommissionPercentage($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan whereCopyTradePlanId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan whereDailyProfit($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan whereDurationDays($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan whereEndsAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan whereStartsAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan whereUnrealizedProfit($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserCopyTradePlan whereUuid($value)
 */
	class UserCopyTradePlan extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property int $plan_id
 * @property numeric $amount
 * @property int $daily_profit
 * @property int $duration
 * @property int $trades_per_day
 * @property string|null $starts_at
 * @property string|null $ends_at
 * @property \App\Enum\UserPlanStatus $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Plan $plan
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereDailyProfit($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereDuration($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereEndsAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan wherePlanId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereStartsAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereTradesPerDay($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereUuid($value)
 */
	class UserPlan extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property string $name
 * @property string $symbol
 * @property string $address
 * @property string $network
 * @property string|null $qr_code_path
 * @property string|null $logo_path
 * @property numeric|null $balance
 * @property \App\Enum\WalletStatus $status
 * @property string|null $description
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereAddress($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereLogoPath($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereNetwork($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereQrCodePath($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereSymbol($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereUuid($value)
 */
	class Wallet extends \Eloquent {}
}

